library IEEE;
use IEEE.std_logic_1164.ALL;
use IEEE.std_logic_unsigned.ALL;

entity I2CIF is
   port (
    RESET       : in std_logic;
    SCLK        : in std_logic;
    SCL         : in std_logic;
    SDAI        : in std_logic;
    SDAO        : out std_logic;
    RDBK        : in std_logic_vector (7 downto 0);
    DATA        : out std_logic_vector (7 downto 0);
    WE          : out std_logic
    );
end I2CIF;

architecture RTL of I2CIF is

constant   slvadr      : std_logic_vector (6 downto 0) := "1100000";

signal   Bit_count     : std_logic_vector (3 downto 0);
signal   getadr        : std_logic_vector (9 downto 0);
signal   sda_int_d     : std_logic;
signal   sda_int_2d    : std_logic;
signal   sda_int_3d    : std_logic;
signal   scl_int_d     : std_logic;
signal   scl_int_2d    : std_logic;
signal   scl_int_3d    : std_logic;
signal   is_scl_rise   : std_logic;
signal   is_scl_fall   : std_logic;
signal   is_sda_rise   : std_logic;
signal   is_sda_fall   : std_logic;
signal   rdbk_d        : std_logic_vector (7 downto 0);
signal   tmp           : std_logic_vector (8 downto 0);

BEGIN

    process(SCLK)
    begin
       if (SCLK' event and SCLK='1' ) then
          sda_int_d <= SDAI;
          sda_int_2d <= sda_int_d;
          sda_int_3d <= sda_int_2d;
       end if;
    end process;

    process(SCLK)
    begin
       if (SCLK' event and SCLK='1' ) then
          scl_int_d <= SCL;
          scl_int_2d <= scl_int_d;
          scl_int_3d <= scl_int_2d;
       end if;
    end process;

    process(SCLK, RESET)
    begin
       if (RESET = '0') then
          Bit_count <= "1000";
       elsif (SCLK' event and SCLK='1' ) then
          if (is_sda_fall = '1' and scl_int_3d = '1' and is_scl_rise = '0' and is_scl_fall = '0') then		-- is START condition
             Bit_count <= "1001";
          elsif (is_scl_fall = '1') then
             if (Bit_count = "0000") then
                Bit_count <= "1000";
             else
                Bit_count <= Bit_count - '1';
             end if;
          end if;
       end if;
    end process;

    is_scl_rise <= '1' when scl_int_2d = '1' and scl_int_3d = '0' else '0';
    is_scl_fall <= '1' when scl_int_2d = '0' and scl_int_3d = '1' else '0';
    is_sda_rise <= '1' when sda_int_2d = '1' and sda_int_3d = '0' else '0';
    is_sda_fall <= '1' when sda_int_2d = '0' and sda_int_3d = '1' else '0';

    process(SCLK, RESET)
    variable CURRENT_STATE : std_logic_vector (1 downto 0);
    variable NEXT_STATE : std_logic_vector (1 downto 0);
    variable SLAV_hit   : std_logic;
    constant IDLE       : std_logic_vector (1 downto 0) := "00";
    constant SLAD       : std_logic_vector (1 downto 0) := "01";
    constant DATAW      : std_logic_vector (1 downto 0) := "10";
    constant DATAR      : std_logic_vector (1 downto 0) := "11";
    begin
       if (RESET='0') then
          CURRENT_STATE := IDLE;
          NEXT_STATE := IDLE;
          SLAV_hit := '0';
          SDAO <= '1';
          WE <= '0';
       elsif (SCLK' event and SCLK='1' ) then
          CURRENT_STATE := NEXT_STATE;
          case CURRENT_STATE is
          when IDLE =>
             SDAO <= '1';
             if (is_sda_fall = '1' and scl_int_3d = '1' and is_scl_rise = '0' and is_scl_fall = '0') then		-- is START condition
                NEXT_STATE := SLAD;
             else
                NEXT_STATE := IDLE;
             end if;
          when SLAD =>
             if (is_scl_fall = '1') then
                getadr(conv_integer(Bit_count)) <= sda_int_3d;
                if (Bit_count = "0001") then
                   if (getadr(8 downto 2) = slvadr) then		-- slave address hit
                      SLAV_hit := '1';
                      SDAO <= '0';					-- asert ack
                   end if;
                elsif (Bit_count = "0000") then
                   if (SLAV_hit = '1') then
                      if (getadr(1) = '0') then
                         SDAO <= '1';					-- negate ack if aserted
                         NEXT_STATE := DATAW;
                      else
                         SDAO <= rdbk_d(7);
                         NEXT_STATE := DATAR;
                      end if;
--                      SLAV_hit := '0';
                   else
                      SDAO <= '1';					-- negate ack if aserted
                      NEXT_STATE := IDLE;
                   end if;
                end if;
             elsif (is_scl_rise = '1') then
                if (Bit_count = "0000") then
                   if (SLAV_hit = '1') then
                      if (getadr(1) = '1') then
                         rdbk_d <= RDBK;
                      end if;
                   end if;
                end if;
             end if;
          when DATAW =>
             if (is_sda_rise = '1' and scl_int_3d = '1' and is_scl_rise = '0' and is_scl_fall = '0') then		-- is STOP condition
                NEXT_STATE := IDLE;
             elsif (is_scl_fall = '1') then
                tmp(conv_integer(Bit_count)) <= sda_int_3d;
                if (Bit_count = "0001") then
                   SDAO <= '0';						-- asert ack
                elsif (Bit_count = "0000") then
                   DATA <= tmp(8 downto 1);
                   SDAO <= '1';						-- negate ack
                end if;
             elsif (is_scl_rise = '1') then
                if (Bit_count = "1000") then
                   if (SLAV_hit = '0') then
                      WE <= '1';
                   else
                      WE <= '0';
                   end if;
                   SLAV_hit := '0';
                end if;
             else
                WE <= '0';
             end if;
          when DATAR =>
             if (is_sda_rise = '1' and scl_int_3d = '1' and is_scl_rise = '0' and is_scl_fall = '0') then		-- is STOP condition
                NEXT_STATE := IDLE;
             elsif (is_scl_fall = '1') then
                if (Bit_count = "1000") then
                  SLAV_hit := '0';
                  SDAO <= rdbk_d(6);
                elsif (Bit_count = "0111") then
                   SDAO <= rdbk_d(5);
                elsif (Bit_count = "0110") then
                   SDAO <= rdbk_d(4);
                elsif (Bit_count = "0101") then
                   SDAO <= rdbk_d(3);
                elsif (Bit_count = "0100") then
                   SDAO <= rdbk_d(2);
                elsif (Bit_count = "0011") then
                   SDAO <= rdbk_d(1);
                elsif (Bit_count = "0010") then
                   SDAO <= rdbk_d(0);
                elsif (Bit_count = "0001") then
                   SDAO <= '1';
                elsif (Bit_count = "0000") then
                   if (sda_int_3d = '1') then
                      NEXT_STATE := IDLE;
                   end if;
                else
                   SDAO <= '1';
                end if;
             end if;
          when others => null;
          end case;
       end if;
    end process;

end RTL;
