//-----------------------------------------------------------------------------
//   File:      periph.c
//   Contents:  Hooks required to implement USB peripheral function.
//
// $Archive: /USB/Target/Fw/lp/periph.c $
// $Date: 3/23/05 3:03p $
// $Revision: 3 $
//
//
//-----------------------------------------------------------------------------
// Copyright 2003, Cypress Semiconductor Corporation
//-----------------------------------------------------------------------------
#pragma NOIV               // Do not generate interrupt vectors

#include "fx2.h"
#include "fx2regs.h"
#include "syncdly.h"            // SYNCDELAY macro

extern BOOL   GotSUD;         // Received setup data flag
extern BOOL   GotEP6Isr;
extern BOOL   Sleep;
extern BOOL   Rwuen;
extern BOOL   Selfpwr;

#define FPGA_ADDR		0x60

#define bmVBUS				bmBIT4

BYTE   Configuration;      // Current configuration
BYTE   AlternateSetting;   // Alternate settings
BYTE xdata i2c_data[]={0x0};
BYTE xdata i2c_rdbk[]={0x0};
WORD   freq;

//-----------------------------------------------------------------------------
// Task Dispatcher hooks
//   The following hooks are called by the task dispatcher.
//-----------------------------------------------------------------------------

void TD_Init(void)             // Called once at startup
{
	EZUSB_InitI2C();			// Initialize EZ-USB I2C controller
	// set the CPU clock to 48MHz
	CPUCS = ((CPUCS & ~bmCLKSPD) | bmCLKSPD1) ;

	// set the slave FIFO interface to 48MHz
	IFCONFIG = 0xFB;		// Async inv IFCLK drive

    //set FD bus 8bit
    EP2FIFOCFG = 0x04;
    SYNCDELAY;
    EP4FIFOCFG = 0x04;
    SYNCDELAY;
    EP6FIFOCFG = 0x04;
    SYNCDELAY;
    EP8FIFOCFG = 0x04;
    SYNCDELAY;
      
    REVCTL = 0x03;               // see TRM 15.5.9
    SYNCDELAY;
    EP2CFG = 0x9A;  //(OUT, Size = 1024, buf = Double (Buf x2), ISO);
    SYNCDELAY;                    
    EP6CFG = 0xD2;  //(IN, Size = 512, buf = Double (Buf x2), ISO);
    SYNCDELAY;                    
	EP4CFG = 0x00;
	SYNCDELAY;                    
	EP8CFG = 0x00;
	SYNCDELAY;                    
                    
	OED = 0;
	PINFLAGSAB = 0xE8;	//FLAGA=ep2EF FLAGB=ep6FF
	SYNCDELAY;
                    
	PINFLAGSCD = 0x0C;	//FLAGC=ep2FF FLAGD=default
	SYNCDELAY;
                    
	FIFORESET = 0x80; // activate NAK-ALL to avoid race conditions
	SYNCDELAY;
	FIFORESET = 0x02; // reset, FIFO 2
	SYNCDELAY;
	FIFORESET = 0x00; // deactivate NAK-ALL
	SYNCDELAY;

	EPIE |= bmBIT6; // Enable EP6 IN  Endpoint interrupts

}

void TD_Poll(void)             // Called repeatedly while the device is idle
{
   if ( !(IOD & bmVBUS) )	// if VBUS is not present
   {
      EZUSB_Delay(30);
      if ( !(IOD & bmVBUS) )
      {
         USBCS |= bmDISCON;	// Setting DISCON bit to disable the pull up on D+
      }
   }
   else
   {
      USBCS &= ~bmDISCON;	// Clear DISCON

      if (GotEP6Isr)
      {
         EZUSB_ReadI2C(FPGA_ADDR, 1, &i2c_rdbk);
         switch(freq)
         {
            case 0x7700:			// 96,000Hz
               if ((i2c_rdbk[0] >> 6) == 0)		// i2c_rdbk[0] < 0x40
               {
                  EP6FIFOBUF[0] = 0;
                  EP6FIFOBUF[1] = 0x40;
                  EP6FIFOBUF[2] = 0x18;
               }
               else if ((i2c_rdbk[0] >> 6) == 0x3)		// i2c_rdbk[0] >= 0xC0
               {
                  EP6FIFOBUF[0] = 0;
                  EP6FIFOBUF[1] = 0xC0;
                  EP6FIFOBUF[2] = 0x17;
               }
               else
               {
                  EP6FIFOBUF[0] = 0;
                  EP6FIFOBUF[1] = 0;
                  EP6FIFOBUF[2] = 0x18;
               }
               break;
            case 0x5888:			// 88,200Hz
               if ((i2c_rdbk[0] >> 6) == 0)		// i2c_rdbk[0] < 0x40
               {
                  EP6FIFOBUF[0] = 0;
                  EP6FIFOBUF[1] = 0x40;
                  EP6FIFOBUF[2] = 0x16;
               }
               else if ((i2c_rdbk[0] >> 6) == 0x3)		// i2c_rdbk[0] >= 0xC0
               {
                  EP6FIFOBUF[0] = 0x99;
                  EP6FIFOBUF[1] = 0xD9;
                  EP6FIFOBUF[2] = 0x15;
               }
               else
               {
                  EP6FIFOBUF[0] = 0xCC;
                  EP6FIFOBUF[1] = 0x0C;
                  EP6FIFOBUF[2] = 0x16;
               }
               break;
            case 0xBB80:			// 48,000Hz
               if ((i2c_rdbk[0] >> 6) == 0)		// i2c_rdbk[0] < 0x40
               {
                  EP6FIFOBUF[0] = 0;
                  EP6FIFOBUF[1] = 0x20;
                  EP6FIFOBUF[2] = 0x0C;
               }
               else if ((i2c_rdbk[0] >> 6) == 0x3)		// i2c_rdbk[0] >= 0xC0
               {
                  EP6FIFOBUF[0] = 0;
                  EP6FIFOBUF[1] = 0xE0;
                  EP6FIFOBUF[2] = 0x0B;
               }
               else
               {
                  EP6FIFOBUF[0] = 0;
                  EP6FIFOBUF[1] = 0;
                  EP6FIFOBUF[2] = 0x0C;
               }
               break;
            case 0xAC44:			// 44,100Hz
               if ((i2c_rdbk[0] >> 6) == 0)		// i2c_rdbk[0] < 0x40
               {
                  EP6FIFOBUF[0] = 0;
                  EP6FIFOBUF[1] = 0x20;
                  EP6FIFOBUF[2] = 0x0B;
               }
               else if ((i2c_rdbk[0] >> 6) == 0x3)		// i2c_rdbk[0] >= 0xC0
               {
                  EP6FIFOBUF[0] = 0xCC;
                  EP6FIFOBUF[1] = 0xEC;
                  EP6FIFOBUF[2] = 0x0A;
               }
               else
               {
                  EP6FIFOBUF[0] = 0x66;
                  EP6FIFOBUF[1] = 0x06;
                  EP6FIFOBUF[2] = 0x0B;
               }
               break;
            default:
               EP6FIFOBUF[0] = 0;
               EP6FIFOBUF[1] = 0;
               EP6FIFOBUF[2] = 0;
               break;
         }
         EP6BCH = 0x00;
         SYNCDELAY;
         EP6BCL = 0x03;
         SYNCDELAY;

         GotEP6Isr = FALSE;
      }
   }
}

BOOL TD_Suspend(void)          // Called before the device goes into suspend mode
{
   return(TRUE);
}

BOOL TD_Resume(void)          // Called after the device resumes
{
   return(TRUE);
}

//-----------------------------------------------------------------------------
// Device Request hooks
//   The following hooks are called by the end point 0 device request parser.
//-----------------------------------------------------------------------------

BOOL DR_GetDescriptor(void)
{
   return(TRUE);
}

BOOL DR_SetConfiguration(void)   // Called when a Set Configuration command is received
{
   Configuration = SETUPDAT[2];
   return(TRUE);            // Handled by user code
}

BOOL DR_GetConfiguration(void)   // Called when a Get Configuration command is received
{
   EP0BUF[0] = Configuration;
   EP0BCH = 0;
   EP0BCL = 1;
   return(TRUE);            // Handled by user code
}

BOOL DR_SetInterface(void)       // Called when a Set Interface command is received
{
   AlternateSetting = SETUPDAT[2];

   switch(AlternateSetting)
   {
	  case 0x1:			// is_24bit_h = '1'
		 FIFORESET = 0x02;	// reset, FIFO 2
		 SYNCDELAY;
		 OUTPKTEND = 0x82;
		 SYNCDELAY;
		 OUTPKTEND = 0x82;
		 SYNCDELAY;
		 EP2FIFOCFG = 0x10;	//8bit, Auto-OUT
		 SYNCDELAY;

//         i2c_data[0] = 0x20;
         i2c_data[0] |= 0x20; 						// (10 Aug) inhibit to overwrite previous value
		 EZUSB_WriteI2C(FPGA_ADDR, 1, &i2c_data);
		 EZUSB_WaitForEEPROMWrite(FPGA_ADDR);
		 break;
      case 0:

         FIFORESET = 0x02;	// reset, FIFO 2
         SYNCDELAY;
         EP2FIFOCFG = 0x04;	//8bit
         SYNCDELAY;

//	     i2c_data[0] = 0x0;
	     i2c_data[0] &= 0x3; 						// (10 Aug) inhibit to overwrite previous value
		 EZUSB_WriteI2C(FPGA_ADDR, 1, &i2c_data);
		 EZUSB_WaitForEEPROMWrite(FPGA_ADDR);
	     break;
	  default:
//	     i2c_data[0] = 0x0;
	     i2c_data[0] &= 0x3; 						// (10 Aug) inhibit to overwrite previous value
		 EZUSB_WriteI2C(FPGA_ADDR, 1, &i2c_data);
		 EZUSB_WaitForEEPROMWrite(FPGA_ADDR);
	     break;
   }

   return(TRUE);            // Handled by user code
}

BOOL DR_GetInterface(void)       // Called when a Set Interface command is received
{
   EP0BUF[0] = AlternateSetting;
   EP0BCH = 0;
   EP0BCL = 1;
   return(TRUE);            // Handled by user code
}

BOOL DR_GetCur(void)       // Called when a Get Interface command is received
{
   if (SETUPDAT[3] == 0x1)
   {
      switch(freq)
      {
         case 0x7700:			// 96,000Hz
            EP0BUF[0] = 0;
            EP0BUF[1] = 0x77;
            EP0BUF[2] = 0x01;
		    break;
	     case 0x5888:			// 88,200Hz
            EP0BUF[0] = 0x88;
            EP0BUF[1] = 0x58;
            EP0BUF[2] = 0x01;
		    break;
         case 0xBB80:			// 48,000Hz
            EP0BUF[0] = 0x80;
            EP0BUF[1] = 0xBB;
            EP0BUF[2] = 0;
		    break;
//	  case 0xAC44:			// 44,100Hz
	     default: 
	        EP0BUF[0] = 0x44;
            EP0BUF[1] = 0xAC;
            EP0BUF[2] = 0;
		    break;
//	  default:
//	     break;
      }
      EP0BUF[3] = 0;
   }
   else	 if (SETUPDAT[3] == 0x2)
   {
      EP0BUF[0] = 0x1;
   }

   EP0BCH = 0;
   EP0BCL = SETUPDAT[6];
   return(TRUE);            // Handled by user code
}

BOOL DR_GetStatus(void)
{
   return(TRUE);
}

BOOL DR_ClearFeature(void)
{
   return(TRUE);
}

BOOL DR_SetFeature(void)
{
   return(TRUE);
}

BOOL DR_VendorCmnd(void)
{
   return(TRUE);
}

BOOL DR_SetCur(void)
{
   // Arm endpoint - do it here to clear (after sud avail)
   EP0BCH = 0;
   EP0BCL = 0; // Clear bytecount to allow new data in; also stops NAKing

   while(EP0CS & bmEPBUSY);		// Wait until new data comes into EP0

   freq = 0;
   freq = EP0BUF[0];
   freq |= EP0BUF[1] << 8;

   FIFORESET = 0x06;	// reset, FIFO 6
   SYNCDELAY;
   EP6FIFOCFG = 0x04;	//8bit
   SYNCDELAY;

   switch(freq)
   {
      case 0x7700:			// 96,000Hz
         EP6FIFOBUF[0] = 0;
         EP6FIFOBUF[1] = 0;
         EP6FIFOBUF[2] = 0x18;
	     i2c_data[0] |= 0x3;
		 EZUSB_WriteI2C(FPGA_ADDR, 1, &i2c_data);
		 EZUSB_WaitForEEPROMWrite(FPGA_ADDR);
		 break;
	  case 0x5888:			// 88,200Hz
         EP6FIFOBUF[0] = 0xCC;
         EP6FIFOBUF[1] = 0x0C;
         EP6FIFOBUF[2] = 0x16;
	     i2c_data[0] = (i2c_data[0] & 0xFC) | 0x2;
		 EZUSB_WriteI2C(FPGA_ADDR, 1, &i2c_data);
		 EZUSB_WaitForEEPROMWrite(FPGA_ADDR);
		 break;
      case 0xBB80:			// 48,000Hz
         EP6FIFOBUF[0] = 0;
         EP6FIFOBUF[1] = 0;
         EP6FIFOBUF[2] = 0x0C;
	     i2c_data[0] = (i2c_data[0] & 0xFC) | 0x1;
		 EZUSB_WriteI2C(FPGA_ADDR, 1, &i2c_data);
		 EZUSB_WaitForEEPROMWrite(FPGA_ADDR);
		 break;
	  case 0xAC44:			// 44,100Hz
         EP6FIFOBUF[0] = 0x66;
         EP6FIFOBUF[1] = 0x06;
         EP6FIFOBUF[2] = 0x0B;
	     i2c_data[0] &= 0x20;
		 EZUSB_WriteI2C(FPGA_ADDR, 1, &i2c_data);
		 EZUSB_WaitForEEPROMWrite(FPGA_ADDR);
		 break;
	  default:
	     break;
   }

   EP6BCH = 0x00;
   SYNCDELAY;
   EP6BCL = 0x03;
   SYNCDELAY;

   return(TRUE);
}

//-----------------------------------------------------------------------------
// USB Interrupt Handlers
//   The following functions are called by the USB interrupt jump table.
//-----------------------------------------------------------------------------

// Setup Data Available Interrupt Handler
void ISR_Sudav(void) interrupt 0
{
   GotSUD = TRUE;            // Set flag
   EZUSB_IRQ_CLEAR();
   USBIRQ = bmSUDAV;         // Clear SUDAV IRQ
}

// Setup Token Interrupt Handler
void ISR_Sutok(void) interrupt 0
{
   EZUSB_IRQ_CLEAR();
   USBIRQ = bmSUTOK;         // Clear SUTOK IRQ
}

void ISR_Sof(void) interrupt 0
{
   EZUSB_IRQ_CLEAR();
   USBIRQ = bmSOF;            // Clear SOF IRQ
}

void ISR_Ures(void) interrupt 0
{
   // whenever we get a USB reset, we should revert to full speed mode
   pConfigDscr = pFullSpeedConfigDscr;
   ((CONFIGDSCR xdata *) pConfigDscr)->type = CONFIG_DSCR;
   pOtherConfigDscr = pHighSpeedConfigDscr;
   ((CONFIGDSCR xdata *) pOtherConfigDscr)->type = OTHERSPEED_DSCR;
   
   EZUSB_IRQ_CLEAR();
   USBIRQ = bmURES;         // Clear URES IRQ
}

void ISR_Susp(void) interrupt 0
{
   Sleep = TRUE;
   EZUSB_IRQ_CLEAR();
   USBIRQ = bmSUSP;
}

void ISR_Highspeed(void) interrupt 0
{
   if (EZUSB_HIGHSPEED())
   {
      pConfigDscr = pHighSpeedConfigDscr;
      ((CONFIGDSCR xdata *) pConfigDscr)->type = CONFIG_DSCR;
      pOtherConfigDscr = pFullSpeedConfigDscr;
      ((CONFIGDSCR xdata *) pOtherConfigDscr)->type = OTHERSPEED_DSCR;
   }

   EZUSB_IRQ_CLEAR();
   USBIRQ = bmHSGRANT;
}
void ISR_Ep0ack(void) interrupt 0
{
}
void ISR_Stub(void) interrupt 0
{
}
void ISR_Ep0in(void) interrupt 0
{
}
void ISR_Ep0out(void) interrupt 0
{
}
void ISR_Ep1in(void) interrupt 0
{
}
void ISR_Ep1out(void) interrupt 0
{
}
void ISR_Ep2inout(void) interrupt 0
{
}
void ISR_Ep4inout(void) interrupt 0
{
}

void ISR_Ep6inout(void) interrupt 0
{
   GotEP6Isr = TRUE;
   EZUSB_IRQ_CLEAR();
   EPIRQ = bmBIT6;
}

void ISR_Ep8inout(void) interrupt 0
{
}
void ISR_Ibn(void) interrupt 0
{
}
void ISR_Ep0pingnak(void) interrupt 0
{
}
void ISR_Ep1pingnak(void) interrupt 0
{
}
void ISR_Ep2pingnak(void) interrupt 0
{
}
void ISR_Ep4pingnak(void) interrupt 0
{
}
void ISR_Ep6pingnak(void) interrupt 0
{
}
void ISR_Ep8pingnak(void) interrupt 0
{
}
void ISR_Errorlimit(void) interrupt 0
{
}
void ISR_Ep2piderror(void) interrupt 0
{
}
void ISR_Ep4piderror(void) interrupt 0
{
}
void ISR_Ep6piderror(void) interrupt 0
{
}
void ISR_Ep8piderror(void) interrupt 0
{
}
void ISR_Ep2pflag(void) interrupt 0
{
}
void ISR_Ep4pflag(void) interrupt 0
{
}
void ISR_Ep6pflag(void) interrupt 0
{
}
void ISR_Ep8pflag(void) interrupt 0
{
}
void ISR_Ep2eflag(void) interrupt 0
{
}
void ISR_Ep4eflag(void) interrupt 0
{
}
void ISR_Ep6eflag(void) interrupt 0
{
}
void ISR_Ep8eflag(void) interrupt 0
{
}
void ISR_Ep2fflag(void) interrupt 0
{
}
void ISR_Ep4fflag(void) interrupt 0
{
}
void ISR_Ep6fflag(void) interrupt 0
{
}
void ISR_Ep8fflag(void) interrupt 0
{
}
void ISR_GpifComplete(void) interrupt 0
{
}
void ISR_GpifWaveform(void) interrupt 0
{
}
