;;-----------------------------------------------------------------------------
;;   File:      dscr.a51
;;   Contents:  This file contains descriptor data tables.
;;
;; $Archive: /USB/Examples/Fx2lp/bulkloop/dscr.a51 $
;; $Date: 9/01/03 8:51p $
;; $Revision: 3 $
;;
;;
;;-----------------------------------------------------------------------------
;; Copyright 2003, Cypress Semiconductor Corporation
;;-----------------------------------------------------------------------------;;-----------------------------------------------------------------------------
   
DSCR_DEVICE   equ   1   ;; Descriptor type: Device
DSCR_CONFIG   equ   2   ;; Descriptor type: Configuration
DSCR_STRING   equ   3   ;; Descriptor type: String
DSCR_INTRFC   equ   4   ;; Descriptor type: Interface
DSCR_ENDPNT   equ   5   ;; Descriptor type: Endpoint
DSCR_DEVQUAL  equ   6   ;; Descriptor type: Device Qualifier

DSCR_DEVICE_LEN   equ   18
DSCR_CONFIG_LEN   equ    9
DSCR_INTRFC_LEN   equ    9
DSCR_ENDPNT_LEN   equ    7
DSCR_DEVQUAL_LEN  equ   10

ET_CONTROL   equ   0   ;; Endpoint type: Control
ET_ISO       equ   1   ;; Endpoint type: Isochronous
ET_BULK      equ   2   ;; Endpoint type: Bulk
ET_INT       equ   3   ;; Endpoint type: Interrupt

public      DeviceDscr, DeviceQualDscr, HighSpeedConfigDscr, FullSpeedConfigDscr, StringDscr, UserDscr

MEVEN	macro
    DS	($-DeviceDscr) AND 1
	endm

DSCR   SEGMENT   CODE PAGE

;;-----------------------------------------------------------------------------
;; Global Variables
;;-----------------------------------------------------------------------------
      rseg DSCR      ;; locate the descriptor table in on-part memory.

DeviceDscr:   
      db   DSCR_DEVICE_LEN      ;; Descriptor length
      db   DSCR_DEVICE   ;; Decriptor type
      dw   0002H      ;; Specification Version (BCD)
      db   00H        ;; Device class
      db   00H         ;; Device sub-class
      db   00H         ;; Device sub-sub-class
      db   64         ;; Maximum packet size
      dw   0B404H      ;; Vendor ID
      dw   0310H      ;; Product ID (Sample Device)
      dw   0000H      ;; Product version ID
      db   1         ;; Manufacturer string index
      db   2         ;; Product string index
      db   0         ;; Serial number string index
      db   1         ;; Number of configurations

DeviceQualDscr:
      db   DSCR_DEVQUAL_LEN   ;; Descriptor length
      db   DSCR_DEVQUAL   ;; Decriptor type
      dw   0002H      ;; Specification Version (BCD)
      db   00H        ;; Device class
      db   00H         ;; Device sub-class
      db   00H         ;; Device sub-sub-class
      db   64         ;; Maximum packet size
      db   1         ;; Number of configurations
      db   0         ;; Reserved

HighSpeedConfigDscr:   
      db   DSCR_CONFIG_LEN               ;; Descriptor length
      db   DSCR_CONFIG                  ;; Descriptor type
      db   (HighSpeedConfigDscrEnd-HighSpeedConfigDscr) mod 256 ;; Total Length (LSB)
      db   (HighSpeedConfigDscrEnd-HighSpeedConfigDscr)  /  256 ;; Total Length (MSB)
      db   2      ;; Number of interfaces
      db   1      ;; Configuration number
      db   0      ;; Configuration string
      db   10000000b   ;; Attributes (b7 - buspwr, b6 - selfpwr, b5 - rwu)
      db   50      ;; Power requirement (div 2 ma)

;; Interface Descriptor
      db   DSCR_INTRFC_LEN      ;; Descriptor length
      db   DSCR_INTRFC         ;; Descriptor type
      db   0               ;; Zero-based index of this interface
      db   0               ;; Alternate setting
      db   0               ;; Number of end points 
      db   01H            ;; Interface class (Audio)
      db   01H               ;; Interface sub class (Audio Control)
      db   0               ;; Interface sub sub class
      db   0               ;; Interface descriptor string index

;; Audio Control Interface Header Descriptor
      db   09H      ;; Descriptor length
      db   24H         ;; Descriptor type (Audio Class Interface Descriptor)
      db   01H         ;; Descriptor Sub type
      dw   0001H      ;; Audio Device Class Spec. Version (BCD)
      dw   1E00H      ;; Total Length
      db   01H      ;; bInCollection
      db   01H      ;; baInterfaceNr[1]

;; Audio Control Input Terminal Descriptor
      db   0CH      ;; Descriptor length
      db   24H         ;; Descriptor type (Audio Class Interface Descriptor)
      db   02H         ;; Descriptor Sub type
      db   01H      ;; Terminal ID
      dw   0101H    ;; Terminal type (USB Streaming)
      db   0      ;; bAssocTerminal
      db   02H      ;; bNrChannels
      dw   0300H     ;; wChannelConfig
      db   0      ;; iChannelNames
      db   0      ;; iTerminal

;; Audio Control Output Terminal Descriptor
      db   09H      ;; Descriptor length
      db   24H         ;; Descriptor type (Audio Class Interface Descriptor)
      db   03H         ;; Descriptor Sub type
      db   02H      ;; Terminal ID
      dw   0206H    ;; Terminal type (Digital audio interface)
      db   0      ;; bAssocTerminal
      db   01H      ;; bSourceID
      db   0      ;; iTerminal

;; Interface Descriptor
      db   DSCR_INTRFC_LEN      ;; Descriptor length
      db   DSCR_INTRFC         ;; Descriptor type
      db   01H               ;; Zero-based index of this interface
      db   0               ;; Alternate setting
      db   0               ;; Number of end points 
      db   01H            ;; Interface class (Audio)
      db   02H               ;; Interface sub class (Audio Streaming)
      db   0               ;; Interface sub sub class
      db   0               ;; Interface descriptor string index

;; Interface Descriptor
      db   DSCR_INTRFC_LEN      ;; Descriptor length
      db   DSCR_INTRFC         ;; Descriptor type
      db   01H               ;; Zero-based index of this interface
      db   01H               ;; Alternate setting
      db   02H               ;; Number of end points 
      db   01H            ;; Interface class (Audio)
      db   02H               ;; Interface sub class (Audio Streaming)
      db   0               ;; Interface sub sub class
      db   0               ;; Interface descriptor string index

;; Audio Streaming Class Specific Interface Descriptor
      db   07H      ;; Descriptor length
      db   24H         ;; Descriptor type (Audio Class Interface Descriptor)
      db   01H         ;; Descriptor Sub type
      db   01H      ;; bTerminalLink
      db   04H      ;; bDelay
      dw   0100H    ;; PCM

;; Audio Streaming Format Type Descriptor
      db   14H      ;; Descriptor length
      db   24H         ;; Descriptor type (Audio Class Interface Descriptor)
      db   02H         ;; Descriptor Sub type
      db   01H      ;; Type-1 Format -> L-PCM
      db   02H      ;; bNrChannels
      db   03H      ;; bSubFrameSize
      db   18H      ;; bBitResolution
      db   04H      ;; bSamFreqType
      db   44H      ;; tSamFreq[1]
      db   0ACH      ;; tSamFreq[1]
      db   0        ;; tSamFreq[1]
      db   80H      ;; tSamFreq[2]
      db   0BBH      ;; tSamFreq[2]
      db   0        ;; tSamFreq[2]
      db   88H      ;; tSamFreq[3]
      db   58H      ;; tSamFreq[3]
      db   01H      ;; tSamFreq[3]
      db   0        ;; tSamFreq[4]
      db   77H      ;; tSamFreq[4]
      db   01H      ;; tSamFreq[4]

;; Standard AS Isochronous Audio Data Endpoint Descriptor
      db   09H               ;; Descriptor length
      db   DSCR_ENDPNT       ;; Descriptor type
      db   02H               ;; Endpoint number, and direction
      db   05H               ;; bmAttributes
      dw   0D002H             ;; wMaxPackectSize
      db   04H               ;; Polling interval
      db   0                 ;; bRefresh
      db   86H               ;; bSyncAddress

;; Audio Streaming Class Specific Audio Data Endpoint Descriptor
      db   07H               ;; Descriptor length
      db   25H               ;; Descriptor type
      db   01H               ;; Descriptor Sub type
      db   01H               ;; bmAttributes
      db   0                 ;; bLockDelayUnits
      dw   0                 ;; wLockDelay

;; Standard AS Isochronous Synch Endpoint Descriptor
      db   09H               ;; Descriptor length
      db   DSCR_ENDPNT       ;; Descriptor type
      db   86H               ;; Endpoint number, and direction
      db   01H               ;; bmAttributes
      dw   0300H             ;; wMaxPackectSize
      db   04H               ;; Polling interval
      db   05H               ;; bRefresh
      db   0                 ;; bSyncAddress

HighSpeedConfigDscrEnd:   

	MEVEN

FullSpeedConfigDscr:   
      db   DSCR_CONFIG_LEN               ;; Descriptor length
      db   DSCR_CONFIG                  ;; Descriptor type
      db   (FullSpeedConfigDscrEnd-FullSpeedConfigDscr) mod 256 ;; Total Length (LSB)
      db   (FullSpeedConfigDscrEnd-FullSpeedConfigDscr)  /  256 ;; Total Length (MSB)
      db   2      ;; Number of interfaces
      db   1      ;; Configuration number
      db   0      ;; Configuration string
      db   10000000b   ;; Attributes (b7 - buspwr, b6 - selfpwr, b5 - rwu)
      db   50      ;; Power requirement (div 2 ma)

;; Interface Descriptor
      db   DSCR_INTRFC_LEN      ;; Descriptor length
      db   DSCR_INTRFC         ;; Descriptor type
      db   0               ;; Zero-based index of this interface
      db   0               ;; Alternate setting
      db   0               ;; Number of end points 
      db   01H            ;; Interface class (Audio)
      db   01H               ;; Interface sub class (Audio Control)
      db   0               ;; Interface sub sub class
      db   0               ;; Interface descriptor string index

;; Audio Control Interface Header Descriptor
      db   09H      ;; Descriptor length
      db   24H         ;; Descriptor type (Audio Class Interface Descriptor)
      db   01H         ;; Descriptor Sub type
      dw   0001H      ;; Audio Device Class Spec. Version (BCD)
      dw   1E00H      ;; Total Length
      db   01H      ;; bInCollection
      db   01H      ;; baInterfaceNr[1]

;; Audio Control Input Terminal Descriptor
      db   0CH      ;; Descriptor length
      db   24H         ;; Descriptor type (Audio Class Interface Descriptor)
      db   02H         ;; Descriptor Sub type
      db   01H      ;; Terminal ID
      dw   0101H    ;; Terminal type (USB Streaming)
      db   0      ;; bAssocTerminal
      db   02H      ;; bNrChannels
      dw   0300H     ;; wChannelConfig
      db   0      ;; iChannelNames
      db   0      ;; iTerminal

;; Audio Control Output Terminal Descriptor
      db   09H      ;; Descriptor length
      db   24H         ;; Descriptor type (Audio Class Interface Descriptor)
      db   03H         ;; Descriptor Sub type
      db   02H      ;; Terminal ID
      dw   0206H    ;; Terminal type (Digital audio interface)
      db   0      ;; bAssocTerminal
      db   01H      ;; bSourceID
      db   0      ;; iTerminal

;; Interface Descriptor
      db   DSCR_INTRFC_LEN      ;; Descriptor length
      db   DSCR_INTRFC         ;; Descriptor type
      db   01H               ;; Zero-based index of this interface
      db   0               ;; Alternate setting
      db   0               ;; Number of end points 
      db   01H            ;; Interface class (Audio)
      db   02H               ;; Interface sub class (Audio Streaming)
      db   0               ;; Interface sub sub class
      db   0               ;; Interface descriptor string index

;; Interface Descriptor
      db   DSCR_INTRFC_LEN      ;; Descriptor length
      db   DSCR_INTRFC         ;; Descriptor type
      db   01H               ;; Zero-based index of this interface
      db   01H               ;; Alternate setting
      db   02H               ;; Number of end points 
      db   01H            ;; Interface class (Audio)
      db   02H               ;; Interface sub class (Audio Streaming)
      db   0               ;; Interface sub sub class
      db   0               ;; Interface descriptor string index

;; Audio Streaming Class Specific Interface Descriptor
      db   07H      ;; Descriptor length
      db   24H         ;; Descriptor type (Audio Class Interface Descriptor)
      db   01H         ;; Descriptor Sub type
      db   01H      ;; bTerminalLink
      db   04H      ;; bDelay
      dw   0100H    ;; PCM

;; Audio Streaming Format Type Descriptor
      db   14H      ;; Descriptor length
      db   24H         ;; Descriptor type (Audio Class Interface Descriptor)
      db   02H         ;; Descriptor Sub type
      db   01H      ;; Type-1 Format -> L-PCM
      db   02H      ;; bNrChannels
      db   03H      ;; bSubFrameSize
      db   18H      ;; bBitResolution
      db   04H      ;; bSamFreqType
      db   44H      ;; tSamFreq[1]
      db   0ACH      ;; tSamFreq[1]
      db   0        ;; tSamFreq[1]
      db   80H      ;; tSamFreq[2]
      db   0BBH      ;; tSamFreq[2]
      db   0        ;; tSamFreq[2]
      db   88H      ;; tSamFreq[3]
      db   58H      ;; tSamFreq[3]
      db   01H      ;; tSamFreq[3]
      db   0        ;; tSamFreq[4]
      db   77H      ;; tSamFreq[4]
      db   01H      ;; tSamFreq[4]

;; Standard AS Isochronous Audio Data Endpoint Descriptor
      db   09H               ;; Descriptor length
      db   DSCR_ENDPNT       ;; Descriptor type
      db   02H               ;; Endpoint number, and direction
      db   05H               ;; bmAttributes
      dw   0D002H             ;; wMaxPackectSize
      db   01H               ;; Polling interval
      db   0                 ;; bRefresh
      db   86H               ;; bSyncAddress

;; Audio Streaming Class Specific Audio Data Endpoint Descriptor
      db   07H               ;; Descriptor length
      db   25H               ;; Descriptor type
      db   01H               ;; Descriptor Sub type
      db   01H               ;; bmAttributes
      db   0                 ;; bLockDelayUnits
      dw   0                 ;; wLockDelay

;; Standard AS Isochronous Synch Endpoint Descriptor
      db   09H               ;; Descriptor length
      db   DSCR_ENDPNT       ;; Descriptor type
      db   86H               ;; Endpoint number, and direction
      db   01H               ;; bmAttributes
      dw   0300H             ;; wMaxPackectSize
      db   01H               ;; Polling interval
      db   05H               ;; bRefresh
      db   0                 ;; bSyncAddress

FullSpeedConfigDscrEnd:   

	MEVEN

StringDscr:

StringDscr0:   
      db   StringDscr0End-StringDscr0      ;; String descriptor length
      db   DSCR_STRING
      db   09H,04H
StringDscr0End:

StringDscr1:   
      db   StringDscr1End-StringDscr1      ;; String descriptor length
      db   DSCR_STRING
      db   'C',00
      db   'y',00
      db   'p',00
      db   'r',00
      db   'e',00
      db   's',00
      db   's',00
StringDscr1End:

StringDscr2:   
      db   StringDscr2End-StringDscr2      ;; Descriptor length
      db   DSCR_STRING
      db   'E',00
      db   'Z',00
      db   '-',00
      db   'U',00
      db   'S',00
      db   'B',00
StringDscr2End:

UserDscr:      
      dw   0000H
      end
      
